# coding: UTF-8
##!!!!##################################################################################################
#### Own written code can be placed above this commentblock . Do not change or delete commentblock! ####
########################################################################################################
##** Code created by generator - DO NOT CHANGE! **##

class SpeakerSystemHousehold10705(hsl20_4.BaseModule):

    def __init__(self, homeserver_context):
        hsl20_4.BaseModule.__init__(self, homeserver_context, "SPEAKER_SYSTEM")
        self.FRAMEWORK = self._get_framework()
        self.LOGGER = self._get_logger(hsl20_4.LOGGING_NONE,())
        self.PIN_I_HOUSEHOLD_ID=1
        self.PIN_O_SPEAKERSYSTEM_PLAYER=1
        self.FRAMEWORK._run_in_context_thread(self.on_init)

########################################################################################################
#### Own written code can be placed after this commentblock . Do not change or delete commentblock! ####
###################################################################################################!!!##

    def on_init(self):
        self.registered_devices={} # Registered player and callbacks for an update about the actual played track
        module_id=self._get_module_id() # Get the module (runtime) ID of this instance
        self._set_output_value(self.PIN_O_SPEAKERSYSTEM_PLAYER, module_id) # Pass the module (runtime) ID of this instance to the attached logic modules.
                                                                           # So they can retrieve the instance of this module.

    def on_input_value(self, index, value):
        pass

    """
    SpeakerSystem Player module instances can register here and receive an update when the played track changes.
    """
    def register_for_trackinfo_update(self, device_id, callback):
        register_ok = self.call_speaker_system_api(household_id=self._get_input_value(self.PIN_I_HOUSEHOLD_ID), device_id=device_id, cmd="register_trackinfo")
        if register_ok:
            self.registered_devices[device_id]=callback
        return register_ok

    """
    Triggers the play or pause command for a player.
    """
    def do_play_or_pause(self, device_id):
        return self.call_speaker_system_api(household_id=self._get_input_value(self.PIN_I_HOUSEHOLD_ID), device_id=device_id, cmd="play")

    """
    Dummy method
    Stub for a call of the SpeakerSystem API
    """
    def call_speaker_system_api(self, **args):
        return True

    """
    Dummy method
    Shows a possible feedback of the SpeakerSystem API
    """
    def on_speaker_system_event(self, event_type, **args):
        if(event_type=="trackinfo"):
            device_id=args["device_id"]
            if device_id in self.registered_devices.keys():
                self.registered_devices[device_id](args["info"])
